#' ---
#' author: "Pablo Diego-Rosell, PhD"
#' email: "pablo_diego_rosell@yahoo.com"
#' output:
#'    html_document:
#'      toc: true
#' theme: united
#' ---

rm(list=ls(all=t))

#' #Setup filenames

filename <- "Admin Data - Ecuador_Public Use" # !!!Update filename
functions_vers <-  "functions_1.7.R" # !!!Update helper functions file

#' #Setup data, functions and create dictionary for dataset review
source (functions_vers)
#'
#' Visually inspect variables in "dictionary.csv" and flag for risk, using the following flags: 
# Direct PII: Respondent Names, Addresses, Identification Numbers, Phone Numbers
# Direct PII-team: Interviewer Names, other field team names 
# Indirect PII-ordinal: Date of birth, Age, income, education, household composition. 
# Indirect PII-categorical: Gender, education, ethnicity, nationality,
# occupation, employer, head of household, marital status
# GPS: Longitude, Latitude
# Small Location: Location (<100,000) 
# Large Location (>100,000)
# Weight: weightVar
# Household ID:  hhId, 
# Open-ends: Review responses for any sensitive information, redact as necessary 

#!!!Save flagged dictionary in .csv format, add "DatasetReview" to name and continue processing data with subset of flagged variables

#' #Direct PII: variables to be removed
# !!!No Direct PII
#'
#'
#' #Direct PII-team: Encode field team names
# !!!No Direct PII-team
#'
#' #Small locations: Encode locations  with pop <100,000 using random large numbers
# !!!No small location
#'
#' #Indirect PII - Ordinal: Global recode or Top/bottom coding for extreme values
# Focus on variables with a "Lowest Freq" in dictionary of 30 or less. 
#'
# Top code household composition variables with large and unusual numbers 

mydata <- top_recode ("b_hhsize_2016_masked", break_point=10, missing=c(888, 999999))  # Topcode cases with 10 or more individuals.
mydata <- top_recode ("b_hhsize_2016_imp", break_point=10, missing=c(888, 999999)) # Topcode cases with 10 or more individuals.

#' #Indirect PII - Categorical: Recode, encode, or Top/bottom coding for extreme values
# !!!Include relevant variables in list below (Indirect PII - Categorical, and Ordinal if not processed yet)

indirect_PII <- c("female",
                  "age_at_base",
                  "e_fasis",
                  "e_ffinjust",
                  "e_ffjust",
                  "e_pdfinal",
                  "e_promotion_status",
                  "e_qanual",
                  "b_white_2016",
                  "b_mestizo_2016",
                  "b_afro_2016",
                  "b_montub_2016",
                  "b_indig_2016",
                  "b_ownchild_2016",
                  "b_married_2016",
                  "b_mspan_2016",
                  "b_mnat_2016",
                  "b_fspan_2016",
                  "b_fnat_2016",
                  "b_sameage_2016",
                  "b_younger_2016",
                  "b_older_2016",
                  "b_yearsout_2016",
                  "b_othrace_2016",
                  "b_afro_2016_imp",
                  "b_fspan_2016_imp",
                  "b_married_2016_imp",
                  "b_mestizo_2016_imp",
                  "b_mspan_2016_imp",
                  "b_older_2016_imp",
                  "b_othrace_2016_imp",
                  "b_ownchild_2016_imp",
                  "b_sameage_2016_imp",
                  "b_white_2016_imp",
                  "b_yearsout_2016_imp",
                  "b_younger_2016_imp")

capture_tables (indirect_PII)


# Recode those with very specific values. 

# Combine races' variables in  other races' variable in order to reduce risk of re-identification.

mydata$b_othrace_2016 <- cbind(mydata$b_montub_2016,mydata$b_indig_2016, mydata$b_othrace_2016)
mydata <- mydata[!names(mydata) %in% c("b_indig_2016", "b_montub_2016")]

#' #Matching and crosstabulations: Run automated PII check 

# Based on dictionary inspection, select variables for creating sdcMicro object
# See: https://sdcpractice.readthedocs.io/en/latest/anon_methods.html
# All variable names should correspond to the names in the data file
# selected categorical key variables: gender, occupation/education and age
selectedKeyVars = c('female', 'age_at_base', 'b_white_2016') ##!!! Replace with candidate categorical demo vars

# weight variable (add if available)
# selectedWeightVar = c('projwt') ##!!! Replace with weight var

# household id variable (cluster)
# selectedHouseholdID = c('wpid') ##!!! Replace with household id

# creating the sdcMicro object with the assigned variables
sdcInitial <- createSdcObj(dat = mydata, keyVars = selectedKeyVars)
sdcInitial
# All cases meet 2-anonimity

#' #Open-ends: review responses for any sensitive information, redact as necessary
#' 
# !!! Identify open-end variables here: 
open_ends <- c("e_fecom")
report_open (list_open_ends = open_ends)
mydata <- mydata[!names(mydata) %in% open_ends]

# Review "verbatims.csv". Identify variables to be deleted or redacted and their row number 
#' #GPS data: Displace
# !!!No GPS data

#' #Save processed data in Stata and SPSS format
#' Adds "_PU" (Public Use) to the end of the name 

haven::write_dta(mydata, paste0(filename, "_PU.dta"))
haven::write_sav(mydata, paste0(filename, "_PU.sav"))

# Add report title dynamically
title_var <- paste0("DOL-ILAB SDC - ", filename)
#'---
#'  title: `r title_var`
#'---
